/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class DropHandler {
    public static DropHandler instance = new DropHandler();
    public static boolean playerPvPOnly = true;
    public static boolean mobPvEOnly = true;
    public static boolean playersEnabled = true;
    public static boolean creeperEnabled = true;
    public static boolean skeletonEnabled = true;
    public static boolean witherSkeletonEnabled = false;
    public static boolean zombieEnabled = true;
    public static int playerChance = 5;
    public static int creeperChance = 5;
    public static int skeletonChance = 5;
    public static int witherSkeletonChance = 5;
    public static int zombieChance = 5;

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent livingDropsEvent) {
        EntitySkeleton entitySkeleton;
        if (livingDropsEvent.specialDropValue < 5) {
            return;
        }
        int n = MathHelper.RANDOM.nextInt(100);
        ItemStack itemStack = null;
        if (livingDropsEvent.entity instanceof EntityPlayerMP) {
            if ((livingDropsEvent.recentlyHit || !playerPvPOnly) && playersEnabled && n < playerChance) {
                entitySkeleton = (EntityPlayerMP)livingDropsEvent.entity;
                itemStack = new ItemStack(Items.skull, 1, 3);
                itemStack.stackTagCompound = new NBTTagCompound();
                itemStack.stackTagCompound.setString("SkullOwner", entitySkeleton.getCommandSenderName());
            }
        } else if (livingDropsEvent.recentlyHit || !mobPvEOnly) {
            if (livingDropsEvent.entity instanceof EntitySkeleton) {
                entitySkeleton = (EntitySkeleton)livingDropsEvent.entity;
                if (entitySkeleton.getSkeletonType() == 0 && skeletonEnabled && n < skeletonChance) {
                    itemStack = new ItemStack(Items.skull, 1, 0);
                } else if (entitySkeleton.getSkeletonType() == 1 && witherSkeletonEnabled && n < witherSkeletonChance) {
                    itemStack = new ItemStack(Items.skull, 1, 1);
                }
            } else if (livingDropsEvent.entity instanceof EntityZombie && zombieEnabled && n < zombieChance) {
                itemStack = new ItemStack(Items.skull, 1, 2);
            } else if (livingDropsEvent.entity instanceof EntityCreeper && creeperEnabled && n < creeperChance) {
                itemStack = new ItemStack(Items.skull, 1, 4);
            }
        }
        if (itemStack == null) {
            return;
        }
        entitySkeleton = new EntityItem(livingDropsEvent.entityLiving.worldObj, livingDropsEvent.entityLiving.posX, livingDropsEvent.entityLiving.posY, livingDropsEvent.entityLiving.posZ, itemStack);
        entitySkeleton.delayBeforeCanPickup = 10;
        livingDropsEvent.drops.add(entitySkeleton);
    }
}

